IF OBJECT_ID(N'RPT_Productos_Cob_Detalle','U') IS NOT NULL
	DROP TABLE RPT_Productos_Cob_Detalle
GO

CREATE TABLE RPT_Productos_Cob_Detalle(
	Imp_Gravado_Item DECIMAL(14, 2) NULL,
	Imp_Final_Item DECIMAL(14, 2) NULL,
	Id_Trans_Fac INT NOT NULL,
	Importe_Fac DECIMAL(14, 2) NULL,
	Imp_total_Fac DECIMAL(14, 2) NULL,
	Id_Trans_Rec INT NOT NULL,
	Importe_Aplicado DECIMAL(14, 2) NULL,
	Fecha_QA DATETIME NULL,
	Fecha_Venc DATETIME NULL,
	Id_cliente INT NULL,
	Nombre_Fantasia VARCHAR(100) NULL,
	Id_Cliente_Externo VARCHAR(14) NULL,
	Razon_Social VARCHAR(100) NULL,
	Id_Tipo_Cli SMALLINT NULL,
	Desc_Factura VARCHAR(100) NULL,
	Fecha DATETIME NULL,
	Desc_Recibo VARCHAR(100) NULL,
	Fecha_Rec DATETIME NULL,
	Imp_Total_Rec DECIMAL(14, 2) NULL,
	Id_Estado_Cbte SMALLINT NULL,
	Cotizacion_Rec DECIMAL(9, 4) NULL,
	Cotizacion_Fac DECIMAL(9, 4) NULL,
	Porc_Bonificacion DECIMAL(5, 2) NULL,
	Id_Cobrador VARCHAR(10) NULL,
	Id_Producto VARCHAR(14) NULL,
	Descripcion_Detallada VARCHAR(150) NULL,
	Id_Familia INT NULL,
	Descripcion_Familia VARCHAR(35) NOT NULL,
	Porc_Aplicado DECIMAL(20, 8) NULL, 
	Imp_Prod_CIva DECIMAL(12, 2) NULL,
	Imp_Prod_SIva DECIMAL(12, 2) NULL,
	Nombre_Cobrador VARCHAR(60) NULL,
	Id_Tipo_Cli_Ori SMALLINT NULL,
	Descripcion_Tipo_Cli VARCHAR(200) NULL,
	Id_Cliente_Ref INT NOT NULL,   
	EFECTIVO DECIMAL(14, 2) NULL,
	TARJETA DECIMAL(14, 2) NULL,
	CHEQ_TER DECIMAL(14, 2) NULL,
	CHEQ_PROP DECIMAL(14, 2) NULL,
	DEBITO DECIMAL(14, 2) NULL,
	FINANC DECIMAL(14, 2) NULL,
	OTROS DECIMAL(14, 2) NULL,
	APLIC DECIMAL(14, 2) NULL,
	Total_Pagos DECIMAL(12, 2) NULL,
	Dif DECIMAL(14, 2) NULL,
	Item_Fac SMALLINT NULL,
	Coef_Pago DECIMAL(12, 5) NULL,
	Id_Cond_Pago SMALLINT NOT NULL,
	Cond_Pago VARCHAR(50) NOT NULL,
	Imp_Total_Percep_Reten_Fac DECIMAL(14, 2) NULL,
	Imp_Total_Percep_Reten_Rec DECIMAL(14, 2) NULL,
	FC_CL_Nombre_Fantasia VARCHAR(100) NULL,
	FC_CL_Id_Cliente_Externo VARCHAR(14) NULL,
	FC_CL_Razon_Social VARCHAR(100) NULL,
	FC_CL_Id_Tipo_Cli SMALLINT NULL,
	CL_Id_Cobrador VARCHAR(10) NULL,
	Id_Caja INT NULL,
	Porc_Bonif_Item DECIMAL(14, 2) NULL,
	Imp_Final_Item_Sin_Desc DECIMAL(14, 2) NULL,
	Imp_Bonif_Item DECIMAL(14, 2) NULL,
	Cantidad_Prod DECIMAL(14, 2) NULL,
	Alias SMALLINT NULL,
	Id_Centro_Costo char(10) NULL,
	Fac_Fecha_Mov VARCHAR(20) NULL,
	Rec_Fecha_Mov VARCHAR(20) NULL,
	Importe DECIMAL(14, 2) NULL,
	Id_Periodo_Caja INT NULL,
	Id_Tipo_Cbte_Fac char(4) NULL,
	Descripcion_Fac VARCHAR(100) NULL,
	Imp_Final DECIMAL(15, 5) NULL,
	Coef DECIMAL(16, 8) NULL,    
	Id_Tipo_Val char(3) NULL,
	Coef_Val DECIMAL(11, 6) NULL,   
	Ajustes DECIMAL(14, 2) NULL,
	Acuenta DECIMAL(14, 2) NULL,
	Item SMALLINT NULL           
)
GO

IF IndexProperty(Object_Id('RPT_Productos_Cob_Detalle'), 'IX_Rpt_PCD_PorFecha', 'IndexID') IS  NULL
	CREATE INDEX IX_Rpt_PCD_PorFecha ON RPT_Productos_Cob_Detalle (Fecha_Rec,Id_Producto)
GO


IF IndexProperty(Object_Id('RPT_Productos_Cob_Detalle'), 'IX_Rpt_PCD_PorProd', 'IndexID') IS  NULL
	CREATE INDEX IX_Rpt_PCD_PorProd ON RPT_Productos_Cob_Detalle (Id_Producto,Fecha_Rec)
GO

IF IndexProperty(Object_Id('RPT_Productos_Cob_Detalle'), 'IX_Rpt_PCD_PorFlia', 'IndexID') IS  NULL
	CREATE INDEX IX_Rpt_PCD_PorFlia ON RPT_Productos_Cob_Detalle (Id_Familia,Fecha_Rec)
GO


IF IndexProperty(Object_Id('RPT_Productos_Cob_Detalle'), 'IX_Rpt_PCD_PorTipo', 'IndexID') IS  NULL
	CREATE INDEX IX_Rpt_PCD_PorTipo ON RPT_Productos_Cob_Detalle (Id_Tipo_Cli,Fecha_Rec)
GO

IF IndexProperty(Object_Id('RPT_Productos_Cob_Detalle'), 'IX_Rpt_PCD_PorCC', 'IndexID') IS  NULL
	CREATE INDEX IX_Rpt_PCD_PorCC ON RPT_Productos_Cob_Detalle (Id_Centro_Costo,Fecha_Rec)
GO
